/*
 * Decompiled with CFR 0.152.
 */
package net.jayjay.dangerzone.entity;

import net.jayjay.dangerzone.block.Block;
import net.jayjay.dangerzone.block.Blocks;
import net.jayjay.dangerzone.client.DZ2;
import net.jayjay.dangerzone.entity.Entity;
import net.jayjay.dangerzone.entity.EntityPlayer;
import net.jayjay.dangerzone.phys.AABB;
import net.jayjay.dangerzone.render.Tesselator;
import net.jayjay.dangerzone.sound.Sound;
import net.jayjay.dangerzone.texture.Textures;
import net.jayjay.dangerzone.world.World;
import org.lwjgl.opengl.GL11;

public class EntityBlock
extends Entity {
    private float xd;
    private float yd;
    private float zd;
    private int age;
    private int lifetime;
    private int pickupDelay;
    private float size;
    private static int itemCount = 0;
    private static final int MAX_ITEMS = 256;
    public int id;
    public int count;

    public EntityBlock(World world) {
        super(world);
    }

    public EntityBlock(World level, float x, float y, float z, Block block, int count) {
        super(level);
        if (itemCount >= 256) {
            System.out.println("EntityBlock limit reached: " + itemCount + "/" + 256);
            this.remove();
            return;
        }
        ++itemCount;
        this.setSize(0.5f, 0.5f);
        this.heightOffset = this.bbHeight / 2.0f;
        this.setPos(x + 0.5f, y + 0.5f, z + 0.5f);
        this.xd = (float)(Math.random() * 0.2 - 0.1);
        this.yd = 0.2f;
        this.zd = (float)(Math.random() * 0.2 - 0.1);
        this.size = 0.5f;
        this.lifetime = 6000;
        this.pickupDelay = 10;
        this.age = 0;
        this.onGround = false;
        this.id = Blocks.getBlockID(block.blockTag);
        this.count = count;
    }

    @Override
    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        ++this.age;
        if (this.age >= this.lifetime) {
            this.remove();
            return;
        }
        this.yd -= 0.04f;
        this.move(this.xd, this.yd, this.zd);
        this.xd *= 0.98f;
        this.yd *= 0.98f;
        this.zd *= 0.98f;
        if (this.onGround) {
            this.xd *= 0.7f;
            this.zd *= 0.7f;
            this.yd *= -0.5f;
        }
        if (this.pickupDelay > 0) {
            --this.pickupDelay;
        } else {
            AABB itemBox;
            EntityPlayer player = DZ2.getInstance().thePlayer;
            if (player != null && !player.removed && !this.removed && (itemBox = this.getBoundingBox()) != null) {
                itemBox = itemBox.expand(0.5f, 0.5f, 0.5f);
                AABB playerBox = player.getBoundingBox();
                if (playerBox != null && itemBox.intersects(playerBox)) {
                    this.onPlayerPickup(player);
                }
            }
        }
    }

    private void onPlayerPickup(EntityPlayer player) {
        System.out.println("EntityBlock picked up by player: ID=" + this.id + " Count=" + this.count);
        if (DZ2.getInstance().ci.addItem(this.id, this.count, true)) {
            this.remove();
        }
    }

    @Override
    public void setEntityBB(float width, float height) {
        this.bbWidth = width;
        this.bbHeight = height;
        float w = width / 2.0f;
        float h2 = height / 2.0f;
        this.bb = new AABB(this.x - w, this.y - h2, this.z - w, this.x + w, this.y + h2, this.z + w);
    }

    @Override
    public AABB getBoundingBox() {
        return this.bb;
    }

    @Override
    public void render(float partialTicks) {
        Tesselator t = Tesselator.INSTANCE;
        Block block = Blocks.getBlockById(this.id);
        if (block != null && block.texturePath != null) {
            Textures.bindNearest(block.texturePath);
        }
        GL11.glEnable(3553);
        t.begin(7);
        this.renderBatched(t, partialTicks);
        t.flush();
        GL11.glDisable(3553);
    }

    private void renderCubed(Tesselator t, float partialTicks, float yOffset) {
        float u0 = 0.0f;
        float u1 = 1.0f;
        float v0 = 0.0f;
        float v1 = 1.0f;
        float x = this.xo + (this.x - this.xo) * partialTicks;
        float y = this.yo + (this.y - this.yo) * partialTicks + yOffset;
        float z = this.zo + (this.z - this.zo) * partialTicks;
        float r = 0.25f * this.size;
        float x0 = x - r;
        float x1 = x + r;
        float y0 = y - r;
        float y1 = y + r;
        float z0 = z - r;
        float z1 = z + r;
        t.addVertexWithUV(x0, y0, z1, u0, v1);
        t.addVertexWithUV(x0, y0, z0, u0, v0);
        t.addVertexWithUV(x1, y0, z0, u1, v0);
        t.addVertexWithUV(x1, y0, z1, u1, v1);
        t.addVertexWithUV(x1, y1, z1, u1, v1);
        t.addVertexWithUV(x1, y1, z0, u1, v0);
        t.addVertexWithUV(x0, y1, z0, u0, v0);
        t.addVertexWithUV(x0, y1, z1, u0, v1);
        t.addVertexWithUV(x0, y1, z0, u1, v0);
        t.addVertexWithUV(x1, y1, z0, u0, v0);
        t.addVertexWithUV(x1, y0, z0, u0, v1);
        t.addVertexWithUV(x0, y0, z0, u1, v1);
        t.addVertexWithUV(x0, y1, z1, u0, v0);
        t.addVertexWithUV(x0, y0, z1, u0, v1);
        t.addVertexWithUV(x1, y0, z1, u1, v1);
        t.addVertexWithUV(x1, y1, z1, u1, v0);
        t.addVertexWithUV(x0, y1, z1, u1, v0);
        t.addVertexWithUV(x0, y1, z0, u0, v0);
        t.addVertexWithUV(x0, y0, z0, u0, v1);
        t.addVertexWithUV(x0, y0, z1, u1, v1);
        t.addVertexWithUV(x1, y0, z1, u0, v1);
        t.addVertexWithUV(x1, y0, z0, u1, v1);
        t.addVertexWithUV(x1, y1, z0, u1, v0);
        t.addVertexWithUV(x1, y1, z1, u0, v0);
    }

    public void renderBatched(Tesselator t, float partialTicks) {
        t.setColor(1.0f, 1.0f, 1.0f);
        float bob = (float)Math.sin(((float)this.age + partialTicks) * 0.1f) * 0.1f;
        float yOffset = bob * 0.5f;
        this.renderCubed(t, partialTicks, yOffset);
    }

    @Override
    public void remove() {
        this.removed = true;
        Sound.playDZ2Sound("pickup");
        --itemCount;
    }
}

